import jenkins.model.*
import hudson.security.*
import hudson.model.*
import hudson.tasks.Mailer
import hudson.security.Permission
import groovy.json.*
import static groovy.json.JsonParserType.LAX as RELAX

def adminUser = args[0]

def default_users= args[1]
def jsonSlurper = new JsonSlurper().setType(RELAX)
def jenkins_default_users=jsonSlurper.parseText(default_users.replaceAll("u'","'"))

def instance = Jenkins.getInstance()
def realm = new HudsonPrivateSecurityRealm(false)

instance.setSecurityRealm(realm)

println("\n--> define strategy")
def strategy = new hudson.security.GlobalMatrixAuthorizationStrategy()

def users = instance.securityRealm.getAllUsers()

for (User u : users) {
    println("====\n")
    def displayName = u.getDisplayName()
    def mailAddress = u.getProperty(Mailer.UserProperty.class).getAddress()

    println("Display name is " + displayName)
    println("email is " + mailAddress)

    def userId = u.getId()
    println("userId is " + userId)
    if(userId == adminUser){
        println("-->adminUser (" + userId + ") set permission to Jenkins.ADMINISTER")
        strategy.add(Jenkins.ADMINISTER, userId) 
    }
    else{
      def userProps=jenkins_default_users[userId]
      if(userProps){
        println("user props " + userProps)
        println("${userProps.keySet()}")
        def perms = userProps.get('perm')
        println("perm class: " + perms.class)
        if(perms instanceof List){
          for (perm in perms){
            Permission p=convertToPerm(perm)
            println("--> set permission to " + p + " for " + userId)
            strategy.add(p,userId)
          }
        }
        else{
            Permission p=convertToPerm(perms)
            println("--> set permission (${perms}) for " + userId + " to " + p)
            strategy.add(p,userId)
        }
      }
      else{
        println("not a default user")
      }
    }
}

instance.setAuthorizationStrategy(strategy)
instance.save()

def convertToPerm(val) {
    Permission result
    def resultString
    def jenkinsGroup="hudson.model.Hudson"
    def computerGroup="hudson.model.Computer"
    def jobGroup="hudson.model.Item"
    def runGroup="hudson.model.Run"
    def viewGroup="hudson.model.View"
    def scmGroup="hudson.scm.SCM"

    def groupval=val.tokenize(".")[0].toLowerCase()
    def permval=val.tokenize(".")[1].toLowerCase()
    switch (groupval) {
        case 'jenkins':
            resultString = jenkinsGroup + "." + permval.capitalize()
            break
        case 'hudson':
            resultString = jenkinsGroup + "." + permval.capitalize()
            break
        case 'computer':
            resultString = computerGroup + "." + permval.capitalize()
            break
        case 'item':
            resultString = jobGroup + "." + permval.capitalize()
            break
        case 'job':
            resultString = jobGroup + "." + permval.capitalize()
            break
        case 'run':
            resultString = runGroup + "." + permval.capitalize()
            break
        case 'scm':
            resultString = scmGroup + "." + permval.capitalize()
            break
        case 'view':
            resultString = viewGroup + "." + permval.capitalize()
            break
    }   
    println (" get permission for " + resultString)
    result = Permission.fromId(resultString)
    result
}